//
//  YHFamilyMemberInfoCell.swift
//  galaxy
//
//  Created by edy on 2024/8/16.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHFamilyMemberInfoCell: UITableViewCell {
    
    static let cellReuseIdentifier = "YHFamilyMemberInfoCell"
    
    func updateModel(_ model: YHApplicantInfoModel) {
        self.relationLabel.text = model.info.getRelation()
        self.nameLabel.text = model.info.name
        self.pinyinLabel.text = "\(model.info.familyName) \(model.info.givenName)"
        self.statusLabel.text = model.confirmStatus == 1 ? "已确认" : "待核对"
        let textColor: UIColor = model.confirmStatus == 1 ? .init(hex: 0x3CC694) : .brandMainColor
        self.statusLabel.textColor = textColor
        
        let img = UIImage(named: "family_info_status_arrow")?.withRenderingMode(.alwaysTemplate)
        self.arrowImgView.image = img
        self.arrowImgView.tintColor = textColor
    }
    
    lazy var lineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    lazy var relationLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.text = "主审人"
        label.textColor = UIColor.mainTextColor
        return label
    }()
    
    lazy var nameLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_M(ofSize: 14)
        label.text = "张山峰"
        label.textColor = UIColor.mainTextColor
        return label
    }()
    
    lazy var pinyinLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_R(ofSize: 12)
        label.text = "ZHANG SHANGFENG"
        label.textColor = UIColor.mainTextColor(alpha: 0.5)
        return label
    }()
    
    lazy var statusLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.text = "待核对"
        label.textColor = UIColor.brandMainColor
        return label
    }()
    
    lazy var arrowImgView: UIImageView = {
        let view = UIImageView(image: UIImage(named: "family_info_status_arrow"))
        return view
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        self.backgroundColor = .clear
        self.contentView.backgroundColor = .clear
        contentView.addSubview(relationLabel)
        contentView.addSubview(nameLabel)
        contentView.addSubview(pinyinLabel)
        contentView.addSubview(statusLabel)
        contentView.addSubview(arrowImgView)
        contentView.addSubview(lineView)

        lineView.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.top.equalToSuperview()
            make.height.equalTo(0.5)
        }
        
        relationLabel.snp.makeConstraints { make in
            make.left.equalTo(18.0)
            make.width.equalTo(42)
            make.centerY.equalToSuperview()
        }
        
        nameLabel.snp.makeConstraints { make in
            make.left.equalTo(relationLabel.snp.right).offset(60)
            make.right.equalTo(statusLabel.snp.left).offset(-14)
            make.top.equalTo(16)
            make.height.equalTo(20)
        }
        
        pinyinLabel.snp.makeConstraints { make in
            make.left.equalTo(nameLabel)
            make.right.equalTo(nameLabel)
            make.top.equalTo(nameLabel.snp.bottom)
            make.height.equalTo(17)
        }
        
        arrowImgView.snp.makeConstraints { make in
            make.width.height.equalTo(20)
            make.right.equalTo(-18)
            make.centerY.equalToSuperview()
        }
        
        statusLabel.snp.makeConstraints { make in
            make.width.equalTo(56)
            make.right.equalTo(arrowImgView.snp.left)
            make.height.equalTo(20)
            make.centerY.equalToSuperview()
        }
    }
    
}
